/**
 * Javascript Module to handle changes which are made to the course > edit settings
 * form as the user changes various options
 * e.g. if user deselects one item, this deselects another linked one for them
 * if the user picks an invalid option it will be detected by format_tiles::edit_form_validation (lib.php)
 * but this is to help them avoid triggering that if they have JS enabled
 *
 * @module      format_tiles/edit_form_helper
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */
define("format_tiles/edit_form_helper",["jquery","core/notification","core/str","core/templates"],(function($,Notification,str,Templates){return{init:function(pageType,courseDefaultIcon,courseId,allowphototiles,documentationUrl,activitydocsurl){$(document).ready((function(){const useSubTilesCheckBox=$("input#id_courseusesubtiles"),useSubTilesSecZeroCheckBox=$("input#id_usesubtilesseczero");useSubTilesCheckBox.prop("checked")||(useSubTilesSecZeroCheckBox.prop("checked",!1),useSubTilesSecZeroCheckBox.attr("disabled",!0)),useSubTilesCheckBox.change((function(){useSubTilesCheckBox.prop("checked")?($("input#id_courseusebarforheadings").prop("checked",!1),useSubTilesSecZeroCheckBox.attr("disabled",!1)):(useSubTilesSecZeroCheckBox.prop("checked",!1),useSubTilesSecZeroCheckBox.attr("disabled",!0))})),$("select#id_courseshowtileprogress").change((function(e){if("0"!==e.currentTarget.value){var enableCompBox=$("select#id_enablecompletion");"0"===enableCompBox.val()&&(enableCompBox.val("1"),str.get_strings([{key:"completion",component:"completion"},{key:"completionswitchhelp",component:"format_tiles",param:'<a href="'.concat(activitydocsurl,'" target="_blank">').concat(activitydocsurl,"</a>")}]).done((function(s){Notification.alert(s[0],s[1])})))}})),$("select#id_enablecompletion").change((function(e){"0"===e.currentTarget.value&&$("select#id_courseshowtileprogress").val("0")}));var selectedIconName,selectBox,currentIcon,colourSelectMenu=$("select#id_basecolour");(Templates.render("format_tiles/colour_picker",{colours:colourSelectMenu.find("option").map((function(index,option){var optselector=$(option),colour=optselector.attr("value");return{colour:colour,colourname:optselector.text(),selected:colour===colourSelectMenu.val(),id:colour.replace("#","")}})).toArray()}).done((function(html){$(html).insertAfter(colourSelectMenu),colourSelectMenu.hide();var circles=$(".colourpickercircle");circles.click((function(e){var clicked=$(e.currentTarget);circles.removeClass("selected"),clicked.addClass("selected"),colourSelectMenu.val(clicked.data("colour")),$("#colourselectnotify").fadeIn(200).fadeOut(1200)})),colourSelectMenu.change((function(){circles.removeClass("selected"),$("#colourpick_"+colourSelectMenu.val().replace("#","")).addClass("selected")}));var body=$("body");body.hasClass("format-tiles")||body.addClass("format-tiles")})),"course-edit"===pageType)&&(selectBox=$("#id_defaulttileicon"),selectedIconName=$("#id_defaulttileicon option:selected").text(),currentIcon=""===selectBox.val()?courseDefaultIcon:selectBox.val(),Templates.render("format_tiles/icon_picker_launch_btn",{initialicon:currentIcon,initialname:selectedIconName,sectionId:0,allowphototiles:!1}).done((function(html){$(html).insertAfter(selectBox),selectBox.hide(),require(["format_tiles/edit_icon_picker"],(function(iconPicker){iconPicker.init(courseId,pageType,!1,documentationUrl)}))})));Templates.render("format_tiles/edit_form_helptext",{documentationurl:documentationUrl+"teachers"}).done((function(html){$(html).appendTo($("#id_courseformathdr .fcontainer"))}))}))}}}));

//# sourceMappingURL=edit_form_helper.min.js.map